/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.util;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;

public final class PlatformUtils {
    private PlatformUtils() {
    }

    public static void openEditor(IFile file) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (PartInitException e) {
            SonarLintCorePlugin.getDefault().error(e.getMessage(), (Throwable)e);
        }
    }

    public static void openEditor(IFile file, Integer line) {
        if (line == null) {
            PlatformUtils.openEditor(file);
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>(1);
            map.put("lineNumber", line);
            IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttributes(map);
            IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            SonarLintCorePlugin.getDefault().error(e.getMessage(), (Throwable)e);
        }
    }
}

